/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminExportFileDialog;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWAdminExportFile {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    VWAdminResultPane m_resultsPane = null;
    VWTable m_resultsTable = null;
    private String m_fileName = null;
    private String m_sDelimeter = null;

    public VWAdminExportFile(VWAdminResultPane resultsPane) {
        this.m_session = resultsPane.getSession();
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_resultsPane = resultsPane;
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        VWAdminExportFileDialog dlg = new VWAdminExportFileDialog(resultsPane);
        dlg.setVisible(true);
        boolean b_canceled = dlg.getStatus();
        if (b_canceled) {
            return;
        }
        this.m_fileName = dlg.getFileName();
        this.m_sDelimeter = dlg.getDelimeterString();
        this.writeToFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new DataOutputStream(new FileOutputStream(this.m_fileName)))));
            int nRows = this.m_resultsTable.getRowCount();
            int nCols = this.m_resultsTable.getColumnCount();
            int startCol = this.m_resultsPane.getTableModel().getStartIndex();
            String cell = null;
            for (int colIndex = startCol; colIndex < nCols; ++colIndex) {
                String title;
                if (colIndex != startCol) {
                    pw.write(this.m_sDelimeter);
                }
                if ((title = this.getHeaderValue(colIndex)) == null) continue;
                pw.print(title);
            }
            pw.println();
            for (int rowIndex = 0; rowIndex < nRows; ++rowIndex) {
                for (int colIndex = startCol; colIndex < nCols; ++colIndex) {
                    if (colIndex != startCol) {
                        pw.write(this.m_sDelimeter);
                    }
                    if ((cell = this.getCellValue(rowIndex, colIndex)) == null) continue;
                    pw.print(cell);
                }
                pw.println();
            }
            pw.close();
        }
        catch (SecurityException e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_fileSecurityErrMsg, VWResource.s_fileSecurityErrTitle, 0);
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_fileWriteErrMsg, VWResource.s_fileWriteErrTitle, 0);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private String getHeaderValue(int colIndex) {
        TableColumnModel colModel = this.m_resultsTable.getColumnModel();
        String title = null;
        try {
            TableColumn tk = colModel.getColumn(colIndex);
            if (tk.getIdentifier() instanceof String && (title = (String)tk.getIdentifier()) != null) {
                return title;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private String getCellValue(int rowIndex, int colIndex) {
        TableColumnModel colModel = this.m_resultsTable.getColumnModel();
        String cell = null;
        try {
            TableColumn tk = colModel.getColumn(colIndex);
            Object obj = this.m_resultsTable.getModel().getValueAt(rowIndex, colIndex);
            if (obj != null && obj instanceof VWAdminFieldsTableData) {
                obj = ((VWAdminFieldsTableData)obj).getValue();
            }
            int modelColIndex = this.m_resultsTable.convertColumnIndexToModel(colIndex);
            if (tk.getCellRenderer() instanceof VWFieldsCellRenderer) {
                if (obj == null) {
                    cell = ((VWAdminResultTableModelBase)this.m_resultsTable.getModel()).isFieldNameInVWObject(rowIndex, modelColIndex) ? null : new String(VWResource.s_dashString);
                } else if (!(obj instanceof ImageIcon)) {
                    VWFieldsCellRenderer renderer = (VWFieldsCellRenderer)tk.getCellRenderer();
                    cell = VWFieldsCellRenderer.toString(obj);
                } else {
                    cell = null;
                }
            } else if (obj != null) {
                cell = obj.toString();
            }
            if (cell != null) {
                return cell;
            }
            return new String("");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

